<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use App\Operation\Build\Configuration\GenerateDoctrineMappings;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Yaml\Yaml;

final class SetDoctrineMappingsCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:set-doctrine-mappings';

    private XCart $XCart;

    private GenerateDoctrineMappings $generateDoctrineMappings;

    public function __construct(
        XCart $XCart,
        GenerateDoctrineMappings $generateDoctrineMappings
    ) {
        parent::__construct();

        $this->XCart                    = $XCart;
        $this->generateDoctrineMappings = $generateDoctrineMappings;
    }

    protected function configure()
    {
        $this
            ->setDescription('Set doctrine mappings');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Set mappings for entities from modules');

        $this->XCart->writeToFile('config/packages/xcart_doctrine_mappings.yaml', Yaml::dump(($this->generateDoctrineMappings)(), 5));

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
