<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use App\Operation\Build\Configuration\GenerateBundles;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class SetBundlesCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:set-bundles';

    private XCart $XCart;

    private GenerateBundles $generateBundles;

    public function __construct(
        GenerateBundles $generateBundles,
        XCart $XCart
    ) {
        parent::__construct();

        $this->XCart           = $XCart;
        $this->generateBundles = $generateBundles;
    }

    protected function configure()
    {
        $this
            ->setDescription('Set bundles');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Generate bundles list');

        $bundles =  var_export(($this->generateBundles)(), true);
        $this->XCart->writeToFile('config/dynamic/xcart_bundles.php', "<?php return {$bundles};");

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
