<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use App\Operation\Build\PrepareFilesystem;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class PrepareFilesystemCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:prepare-filesystem';

    private XCart $XCart;

    private PrepareFilesystem $prepareFilesystem;

    public function __construct(
        XCart $XCart,
        PrepareFilesystem $prepareFilesystem
    ) {
        parent::__construct();

        $this->XCart             = $XCart;
        $this->prepareFilesystem = $prepareFilesystem;
    }

    protected function configure()
    {
        $this
            ->setDescription('Prepare filesystem (remove some files and dirs)');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Prepare filesystem (remove some files and dirs)');

        $dirs = array_map(
            function ($item) {
                return $this->XCart->getSourcePath() . $item;
            },
            [
                'var/log',
                'var/locale',
                'public/var/images',
                'public/var/resources',
                'var/datacache',
                'var/cache',
                'var/run',
            ]
        );

        ($this->prepareFilesystem)([], $dirs);

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
