<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use Doctrine\DBAL\Connection;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Yaml\Yaml;

final class InitDatabaseCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:init-database';

    private Connection $connection;

    private XCart $XCart;

    public function __construct(
        Connection $connection,
        XCart $XCart
    ) {
        parent::__construct();

        $this->connection = $connection;
        $this->XCart = $XCart;
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Get database schema');

        $data = $this->XCart->run('xcart:service:get-create-migration');
        $queries = Yaml::parse($data);

        $output->writeln(sprintf(' <info>%s queries to execute</info>', count($queries)));

        $this->connection->executeStatement('SET FOREIGN_KEY_CHECKS = 0;');

        $output->write('Execute queries');

        foreach ($queries as $query) {
            $this->connection->executeStatement($query);
        }

        $this->connection->executeStatement('SET FOREIGN_KEY_CHECKS = 1;');

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
