<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use App\Operation\Build\Configuration\GenerateAutoloader;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class GenerateXCartAutoloaderCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:generate-xcart-autoloader';

    private XCart $XCart;

    private GenerateAutoloader $generateAutoloader;

    public function __construct(
        XCart $XCart,
        GenerateAutoloader $generateAutoloader
    ) {
        parent::__construct();

        $this->XCart              = $XCart;
        $this->generateAutoloader = $generateAutoloader;
    }

    protected function configure()
    {
        $this
            ->setDescription('Generate XCart autoloader file ([xcart_root]/vendor/autoload_xcart.php)');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Generate autoloader');

        $this->XCart->writeToFile('vendor/autoload_xcart.php', ($this->generateAutoloader)());

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
