<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class ClearCacheCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:clear-cache';

    private XCart $XCart;

    public function __construct(
        XCart $XCart
    ) {
        parent::__construct();

        $this->XCart = $XCart;
    }

    protected function configure()
    {
        $this
            ->setDescription('Clear xcart cache');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Clear xcart cache');

        $this->XCart->run('cache:clear');

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
