<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Domain\XCart;
use App\Repository\ModuleRepository;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class CallPostInstallActionsCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:call-post-install-actions';

    private XCart $XCart;

    private ModuleRepository $moduleRepository;

    public function __construct(
        XCart $XCart,
        ModuleRepository $moduleRepository
    ) {
        parent::__construct();

        $this->XCart            = $XCart;
        $this->moduleRepository = $moduleRepository;
    }

    protected function configure()
    {
        $this
            ->setDescription('Call post-install actions');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $enabledModules = $this->moduleRepository->getEnabledIds();

        $output->write('Call install actions');

        $this->XCart->run('xcart:service:call-module-hook', array_merge(['install'], $enabledModules));

        $output->writeln(' <info>OK</info>');

        $output->write('Call enable actions');

        $this->XCart->run('xcart:service:call-module-hook', array_merge(['enable'], $enabledModules));

        $output->writeln(' <info>OK</info>');

        $output->write('Call rebuild actions');

        $this->XCart->run('xcart:service:call-module-hook', array_merge(['rebuild'], $enabledModules));

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
