<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command\LowLevel;

use App\Operation\Build\BuildCodeCache;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class BuildCodeCommand extends Command
{
    /**
     * @var string
     */
    protected static $defaultName = 'xcst:ll:build-code';

    private BuildCodeCache $buildCodeCache;

    public function __construct(
        BuildCodeCache $buildCodeCache
    ) {
        parent::__construct();

        $this->buildCodeCache   = $buildCodeCache;
    }

    protected function configure()
    {
        $this
            ->setDescription('Build code cache by stored modules list');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->write('Build code cache');

        ($this->buildCodeCache)();

        $output->writeln(' <info>OK</info>');

        return Command::SUCCESS;
    }
}
