<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace App\Command;

use App\Entity\License;
use App\Repository\LicenseRepository;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

final class LicenseListCommand extends Command
{
    protected static $defaultName = 'xcst:license-list';

    private LicenseRepository $licenseRepository;

    public function __construct(
        LicenseRepository $licenseRepository
    ) {
        parent::__construct();

        $this->licenseRepository = $licenseRepository;
    }

    protected function configure()
    {
        $this->setDescription('Prints the registered licenses list. Options and arguments are not supported.');
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $licenses = $this->licenseRepository->findAll();

        usort($licenses, static function($a, $b) {
            return $a->getKeyType() === License::CORE_KEY_TYPE ? -1 : 1;
        });

        foreach ($licenses as $license) {
            $output->writeln("<info>{$license->getModuleId()} - {$license->getKeyValue()}</info>");
        }

        return Command::SUCCESS;
    }
}
