#!/usr/bin/env bash

cd "$( dirname "$0" )"

Help()
{
  echo "XC55 service-tool installation script"
  echo
  echo "Syntax: install.sh [-h]"
  echo "Options:"
  echo "h\tPrint help and exit"
  echo
}

Force=false

while getopts :f option; do
  case $option in
    f)
      Force=true;;
  esac
done

if [ "$Force" = false ]; then
  echo "This script is for internal use only; do not run it directly. Use bin/install.sh from the root directory of X-Cart instead."
  exit
fi

# Check some ENV variable to be set
./check_env.sh

composer --working-dir=../ --no-scripts install && \

rm -rf ../var/cache && \
./console cache:clear && \
./console assets:install && \

./console doctrine:database:drop --if-exists --force  && \
./console doctrine:database:create && \
./console doctrine:schema:create  && \
./console xcst:ll:init-storage
