#!/usr/bin/env bash

###############################################################################
# This tool is used to check some ENV variables to be set.
# List of variables: APP_SECRET
#                    XCART_INSTALLER_DETAILS_AUTH_CODE
#                    XCART_INSTALLER_DETAILS_SHARED_SECRET_KEY
# Only /.env.local file checked
# If variable is missing or it has an empty value then the value will be
# generated by openssl
###############################################################################

shopt -s xpg_echo

cd "$( dirname "$0" )"

UpdateEnvValue()
{
  File="$1"
  Content=$( cat "$File")

  Variable="$2"
  Value="$3"

  # Check if variable is not present or has not a value
  if ! (echo "$Content" | grep -q "^$Variable=[a-zA-Z0-9]") && true; then
    if echo "$Content" | grep -q "^$Variable="; then
      # Variable is present, but value is empty
      Content=$( echo "$Content" | sed "s/^$Variable=\$/$Variable=$Value/" )
    else
      # Variable is not present
      Content="$Content\n$Variable=$Value"
    fi

    echo "$Content" > "$File"
  fi
}

Path=../../

UpdateEnvValue "$Path.env.local" APP_SECRET $( openssl rand -hex 16 )
UpdateEnvValue "$Path.env.local" XCART_INSTALLER_DETAILS_AUTH_CODE $( openssl rand -hex 8 )
UpdateEnvValue "$Path.env.local" XCART_INSTALLER_DETAILS_SHARED_SECRET_KEY $( openssl rand -hex 16 )
UpdateEnvValue "$Path.env.local" JWT_PASSPHRASE $( openssl rand -hex 16 )
