# Service-tool

## Конфигурация сборок

Для конфигурации сборок используются файлы в папке resources. \
Используется следующий формат файла:
```yaml
Parent: ''
EnabledModules: []
DisabledModules: []
Data: []
DemoData: []
Mutations:
  include: []
  exclude: []
```

- `Parent` - указывается относительный путь родительской конфигурации, которая предварительно обрабатывается по общим правилам.
- `EnabledModules` - список модулей которые должны быть включены. Если указано это поле, то оно полностью перебивает список из родительской конфигурации.
- `DisabledModules` - список модулей которые должны быть включены в сборку но выключенными. Если указано это поле, то оно полностью перебивает список из родительской конфигурации. **(Это пока не реализованно, потребуется для генерации архивов)**
- `Data` - список yaml или sql файлов относительно корня XC которые должны быть загружены **перед** данными модулей.  Если указано это поле, то оно полностью перебивает список из родительской конфигурации. 
- `DemoData` - список yaml или sql файлов относительно корня XC которые должны быть загружены **после** данными модулей.  Если указано это поле, то оно полностью перебивает список из родительской конфигурации.
- `Mutations` - Данные для изменения конфигурации
- `Mutations.include ` - данные которые должны быть добавлены в конфигурацию по ключам основной конфигурации (`EnabledModules`, `DisableModules`, `Data`, `DemoData`).
- `Mutations.exclude ` - данные которые должны быть убраны из конфигурации по ключам основной конфигурации (`EnabledModules`, `DisableModules`, `Data`, `DemoData`).
- **Опциональные измеения в конфигурации.** Внутри блока `Mutations` могут быть указаны опциональные изменения с помощью специального ключа `[optionName].[optionValue]`. На даннынй момент поддерживается только опция `Lang`. 

### Пример

parent.yaml
```yaml
EnabledModules:
  - 'XC-Module1'
  - 'XC-Module2'
Data:
  - 'sql/data.yaml'
  - 'sql/additional_data.yaml'
DemoData:
  - 'sql/demo_data.yaml'
  - 'sql/demo_data_en.yaml'
  - 'sql/additional_demo_data.yaml'
Mutations:
  Lang.ru:
    include:
      EnabledModules:
        - 'XC-ModuleRu'
      DemoData:
        - 'sql/demo_data_ru.yaml'
    exclude:
      DemoData:
        - 'sql/demo_data_en.yaml'
```
config.yaml
```yaml
Parent: 'parent.yaml'
Data:
  - 'sql/new-data.yaml'
  - 'sql/new-additional_data.yaml'
Mutations:
  include:
    EnabledModules:
      - 'XC-Module3'
  Lang.ru:
    include:
      DemoData:
        - 'sql/new-demo_data_ru.yaml'
    exclude:
      DemoData:
        - 'sql/demo_data_ru.yaml'

```
Результат обработки config.yaml, Lang = ru
```yaml
EnabledModules:
  - 'XC-Module1'
  - 'XC-Module2'
  - 'XC-ModuleRu'
  - 'XC-Module3'
Data:
  - 'sql/new-data.yaml'
  - 'sql/new-additional_data.yaml'
DemoData:
  - 'sql/demo_data.yaml'
  - 'sql/additional_demo_data.yaml'
  - 'sql/new-demo_data_ru.yaml'
```

### Проверка конфигурации

`./bin/console xcst:verify-config  [options]`

Options
- `-b, --buildName=BUILDNAME`  Set build name (example: `build/default`, `build/unit`, `built/lite`, etc. See: `resources` folder) **[default: "build/default"]**
- `-l, --language=LANGUAGE`    Set language **[default: "en"]**
- `-d, --development`          Development mode (Добавляются изменения из `additional/dev.yaml`)
- `-p, --production`           Production mode (Добавляются изменения из `additional/prod.yaml`)

В результяте распечатывается обработанная конфигурация, а так же команда для установки XC с выбранной конфигурацией

## Установка

`install.sh [-b build-name] [-l lng] [-a admin-credentials] [-d|p] [-h]`

- `b`       Set build name (example: build/default, build/unit, built/lite, etc. See: resources folder), default is build/default
- `l`       Set language, default is en
- `a`       Set admin credentials (example: login@mail.ru:password)
- `d`       Development mode
- `p`       Production mode
- `h`       Print help and exit

## Testing
To run phpunit test please call
```shell
./bin/phpunit
```
To configure PHPStorm set the `Path to phpunit.phar` variable value in the `Preferences | PHP | Test Frameworks` as a full path to `./bin/phpunit`. Then create a PHPUnit "Run / Debug configuration" and set the `Use alternative configuration file` variable value as a full path to `./phpunit.xml.dist`
