'use strict';

window.onload = () => {
    document.querySelector('.header__inner').addEventListener('click', (e) => {
        e.preventDefault();
        window.scrollTo({top: 0});
        const el = document.querySelector('.scrollbar-container');
        if (el) {
            el.scrollTop = 0;
        }
    });

    const data = JSON.parse(document.getElementById('swagger-data').innerText);

    const options = {
        scrollYOffset: 70,
        theme: {
            sidebar: {
                backgroundColor: '#ffffff'
            },
            rightPanel: {
                backgroundColor: '#ffffff'
            }
        }
    };

    Redoc.init(data.spec, options, document.getElementById('swagger-ui'));
};
