<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

require_once dirname(__DIR__) . '/vendor/autoload.php';

$dotenv = new \Symfony\Component\Dotenv\Dotenv();
$dotenv->loadEnv(dirname(__DIR__) . '/.env');

$envAuthCode = $_ENV['XCART_INSTALLER_DETAILS_AUTH_CODE'] ?? '';

if (!$envAuthCode) {
    die('Environment variable XCART_INSTALLER_DETAILS_AUTH_CODE cannot be empty');
}

$authCode = $_GET['auth_code'] ?? '';

if (!$authCode) {
    die('auth_code is not provided');
}

if ($envAuthCode !== $authCode) {
    die('auth_code is not correct');
}

?>

<!DOCTYPE html>
<html>
<head>
    <title>Rebuild</title>
    <script src="assets/web/common/js/jquery.min.js"></script>
    <script>
      forceCreateScenario();

      function forceCreateScenario () {
        $.ajax({
          type: 'POST',
          contentType: 'application/json',
          dataType: 'json',
          url: '/service.php/api/scenarios',
          data: JSON.stringify({ force : true }),
          success: function (data, textStatus, xhr) {
            if (data.error) {
              showError(data.error);

              return;
            }

            if (data.id) {
              window.location.href = `/rebuild.html?scenarioId=${data.id}&returnURL=/admin/`;
            } else {
              showError('Empty scenario id');
            }
          },
          error: function (xhr, textStatus, errorThrown) {
            showError(errorThrown);
          }
        });
      }

      function showError(consoleMsg)
      {
        console.error(consoleMsg);
        $('#errors').html('Can\'t create scenario for rebuild');
      }
    </script>
</head>

<body>
<div id="errors"></div>
</body>
</html>

<?php

exit(1);
