/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Rebuild
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

sessionStorage.removeItem('enabledModulesWithSettings');
sessionStorage.removeItem('enabledModules');

const currentUrl = new URL(window.location.href);
const params = currentUrl.searchParams;

if (params.get('xcUrl')) {
  sessionStorage.setItem('xcUrl', params.get('xcUrl'));
}

const xcUrl = sessionStorage.getItem('xcUrl') || '';
const isUpgrade = params.get('isUpgrade');

rebuild();

function rebuild () {
  const scenarioId = params.get('scenarioId');
  if (!scenarioId) {
    $('.title').html('Error. ScenarioId is empty');

    return;
  }

  const returnURL = params.get('returnURL');
  if (!returnURL) {
    $('.title').html('Error. ReturnURL is empty');

    return;
  }

  runNextStep(scenarioId, returnURL);
}

function runNextStep (scenarioId, returnURL) {
  $.ajax({
    type: 'GET',
    contentType: 'application/json',
    dataType: 'json',
    timeout: 0,
    url: `${xcUrl}/service.php/api/scenarios/${scenarioId}/rebuild`,
    data: JSON.stringify({}),
    success: function (data, textStatus, xhr) {
      $('.rebuild-starting').hide();
      $('.rebuild-started').show();

      refreshProgressStatus(data);

      if (data.state === 'in_progress') {
        runNextStep(scenarioId, returnURL);
      }

      if (data.state === 'done') {
        $('.progress-bar').addClass('complete');

        const enabledModules = [];
        const enabledModulesWithSettings = [];

        Object.entries(data.transitions).filter(([key, transition]) => {
          if (
            transition.transitionType === 'enable'
            || transition.transitionType === 'install'
          ) {
            enabledModules.push(key);

            if (transition.showSettingsForm) {
              enabledModulesWithSettings.push(key);
            }
          }
        });

        if (enabledModules.length) {
          sessionStorage.setItem(
            'enabledModules',
            JSON.stringify(enabledModules),
          );
        }

        if (enabledModulesWithSettings.length) {
          sessionStorage.setItem(
            'enabledModulesWithSettings',
            JSON.stringify(enabledModulesWithSettings),
          );
        }

        if (isUpgrade) {
          currentUrl.searchParams.delete('isUpgrade');
          currentUrl.searchParams.append('isPostUpgrade', '1');
          window.location.href = currentUrl.href.replace('rebuild.html', 'upgrade.html');  
        } else {
          const redirectURL = decodeURIComponent(returnURL);

          window.location.href = (redirectURL.indexOf('?target=apps') === -1)
            ? decodeURIComponent(returnURL)
            : `${xcUrl}/admin/?target=apps#/success-rebuild?`;
        }
      }
    },
    error: function (xhr, textStatus, errorThrown) {
      if (xhr.responseText === 'clearServiceToolCache') {
        runNextStep(scenarioId, returnURL);
      } else {
        $('.rebuild-starting').hide();
        $('.rebuild-started').hide();
        $('.spinner-ring').hide();

        let errorText = `<span class="error">${xhr.status} ${errorThrown}</span>`;

        if (xhr.responseJSON) {
          const detailedMessage = xhr.responseJSON.detail || xhr.responseJSON.message;

          if (detailedMessage === errorThrown) {
            errorText += `<span class="error">Error details are available in <code>var/log</code></span>`;
            errorText += `<span class="error">Otherwise you can view detailed error information by enabling debug mode (<code>APP_DEBUG=true</code>) and running the update again.</span>`;
          } else {
            errorText += `<span class="error">${xhr.responseJSON.detail || xhr.responseJSON.message}</span>`;
          }
        } else if (xhr.responseText) {
          errorText += `<span class="error">${xhr.responseText}</span>`;
        }

        $('.rebuild-error')
          .prepend(errorText)
          .show();
      }
    },
  });
}

function refreshProgressStatus (data) {
  const progressMessages = data.progressMessages;

  let progressStatus = [];
  let progressStep = '';

  for (let i = 0; i < progressMessages.length; i++) {
    const message = progressMessages[i].message;

    const isNewLine = !(message === '[OK]' || message === '[KO]');

    if (isNewLine) {
      progressStep += '<li class="progress-message">';
    }

    progressStep += progressMessages[i].type !== 'info'
      ? `<span class="${progressMessages[i].type}">${message}</span>`
      : '';

    if (!isNewLine) {
      progressStep += '</li>';

      progressStatus.unshift(progressStep);

      progressStep = '';
    }
  }

  const currentStep = data.metaData.runnerSteps.current;
  const totalSteps = data.metaData.runnerSteps.total;

  $('.progress-inner').css({
    'width': (currentStep * 100 / totalSteps) + '%'
  });

  $('#step-of-steps').html(`${currentStep} of ${totalSteps}`);
  $('.progress-status').html(progressStatus.join(''));
}
