<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

use XCart\Kernel;

ini_set('max_execution_time', 3600);

if (file_exists(dirname(__DIR__) . '/var/.rebuildInBlockingState')) {
    require_once dirname(__DIR__) . '/maintenance.php';

    echo getMaintenancePageContent('We are deploying new changes to our store. One minute and they will go live!');

    exit(1);
}

require_once dirname(__DIR__) . '/vendor/autoload_runtime.php';

return static function (array $context) {
    // We can use only a production autoloader in the boot stage, so it is required to register an autoloader
    // inside this function in case if we need to switch to a development autoloader after the boot stage.
    // Autoloaders registered outside this function are hidden in runtime and can't be unregistered (but still used)
    require_once dirname(__DIR__) . '/vendor/autoload_xcart.php';

    require_once dirname(__DIR__) . '/bootstrap.php';

    return new Kernel($context['APP_ENV'], (bool) $context['APP_DEBUG']);
};
