<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\VendorMessages\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\VendorMessages\Model\MessageRead;

final class MessageReadCallback
{
    public function prePersist(MessageRead $messageRead, LifecycleEventArgs $args): void
    {
        if (!$messageRead->getDate()) {
            $messageRead->setDate(\XLite\Core\Converter::time());
        }
    }
}
