<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\VendorMessages\EntityCallback;

use XC\VendorMessages\Model\Message;
use Doctrine\Persistence\Event\LifecycleEventArgs;

final class MessageCallback
{
    public function prePersist(Message $message, LifecycleEventArgs $args): void
    {
        if (!$message->getDate()) {
            $message->setDate(\XLite\Core\Converter::time());
        }
    }
}
