<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Upselling\DataSource\Product\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\IntegerValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class RelatedOwnerApplier implements ApplierInterface
{
    /**
     * @param IntegerValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        return $queryBuilder
            ->linkLeft('entity.upsellingProducts')
            ->andWhere('upsellingProducts.parentProduct = :parentProductId')
            ->orderBy('upsellingProducts.orderBy')
            ->setParameter('parentProductId', $filterValue->getValue());
    }
}
