<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\UPS\View\Model;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Request;

/**
 * @Extender\Mixin
 */
abstract class ShippingSettings extends \XLite\View\Tabs\ShippingSettings
{
    /**
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();

        if (Request::getInstance()->target === \XC\UPS\View\Model\Settings::UPS_PROCESSOR_ID) {
            $list[] = 'modules/XC/UPS/settings.css';
        }

        return $list;
    }

    protected function getUPSConnectUrl()
    {
        return \XC\UPS\Core\UpsApiService::getInstance()->getConnectUrl();
    }

    protected function hasUPSRefreshToken()
    {
        return \XC\UPS\Core\UpsApiService::getInstance()->hasRefreshToken();
    }
}
