<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\UPS\View\FormField;

use XC\UPS\Core\UpsApiService;

class ResetConnectBlock extends \XLite\View\FormField\Label
{
    protected function getConnectTextLabel(): string
    {
        return static::t('UPS module is connected');
    }

    protected function getResetUrl(): string
    {
        return UpsApiService::getInstance()->getResetUrl();
    }

    protected function getFieldTemplate()
    {
        return 'modules/XC/UPS/form_field/connect.twig';
    }

    protected function getDir()
    {
        return '';
    }
}
