<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\UPS\Model\Shipping\Mapper\RateCOD;

use XC\UPS\Model\Shipping\Mapper\Rate;

class InputMapper extends Rate\InputMapper
{
    protected function getShipmentServiceOptions(): array
    {
        $result = parent::getShipmentServiceOptions();

        $srcCountry = $this->inputData['srcAddress']['country'];
        $dstCountry = $this->inputData['dstAddress']['country'];
        if ($this->isShipmentCODAllowed($srcCountry, $dstCountry)) {
            $shipmentTotal = round((float) $this->inputData['total'], 2);

            $result['COD']['CODFundsCode'] = '9';
            $result['COD']['CODAmount']['CurrencyCode'] = $this->destinationCurrency;
            $result['COD']['CODAmount']['MonetaryValue'] = $shipmentTotal;
        }

        return $result;
    }

    protected function getPackageServiceOptions($package): array
    {
        $result = parent::getPackageServiceOptions($package);
        $packageSubtotal = (string) round((float) $package['subtotal'], 2);

        $srcCountry = $this->inputData['srcAddress']['country'];
        $dstCountry = $this->inputData['dstAddress']['country'];
        if ($this->isPackageCODAllowed($srcCountry, $dstCountry)) {
            unset($result['DeliveryConfirmation']);
            $result['COD']['CODFundsCode'] = '0';
            $result['COD']['CODAmount']['CurrencyCode'] = $this->destinationCurrency;
            $result['COD']['CODAmount']['MonetaryValue'] = $packageSubtotal;
        }

        return $result;
    }
}
