<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\UPS\LifetimeHook\Upgrade;

use XLite\Model\Config;
use Doctrine\ORM\EntityManagerInterface;
use XCart\Doctrine\FixtureLoader;

/**
 * Delete deprecated configs and update shipper_number / delivery_conf
 */
class UpgradeTo552build0
{
    public function __construct(
        private EntityManagerInterface $entityManager,
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . 'XC/UPS/resources/hooks/upgrade/5.5/2.0/upgrade.yaml');

        $this->deleteConfigs();
        $this->updateConfigs();

        $this->entityManager->flush();
    }

    private function deleteConfigs(): void
    {
        /** @var \XLite\Model\Repo\Config $repo */
        $namesToDelete    = ['userID', 'password', 'accessKey'];
        $entitiesToRemove = $this->entityManager->getRepository(Config::class)?->findBy(['name' => $namesToDelete, 'category' => 'XC\UPS']) ?: [];

        foreach ($entitiesToRemove as $entity) {
            $this->entityManager->remove($entity);
        }
    }

    /**
     * Use cycles to support MultiVendor
     */
    private function updateConfigs(): void
    {
        /** @var \XLite\Model\Repo\Config $repo */
        $entitiesToUpdate = $this->entityManager->getRepository(Config::class)?->findBy(['name' => 'shipper_number', 'category' => 'XC\UPS']) ?: [];
        foreach ($entitiesToUpdate as $shipperNumber) {
            $shipperNumber->setOrderby(305); // after 'Pickup type'
        }

        //https://developer.ups.com/api/reference?loc=en_US#operation/Rate!path=RateRequest/Shipment/Package/PackageServiceOptions/DeliveryConfirmation/DCISType&t=request
        $entitiesToUpdate = $this->entityManager->getRepository(Config::class)?->findBy(['name' => 'delivery_conf', 'category' => 'XC\UPS']) ?: [];
        foreach ($entitiesToUpdate as $deliveryConf) {
            if ((int)$deliveryConf?->getValue() === 1) { // 1 is Unsupported in REST API
                $deliveryConf->setValue(0);
            }
        }
    }
}
