<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\UPS\Core;

class Crypter
{
    private const CIPHER_METHOD = 'aes-128-ctr';

    public function __construct(
        private string $passPhrase,
    ) {
    }

    public function encrypt(string $data): string
    {
        $iv = openssl_random_pseudo_bytes(
            openssl_cipher_iv_length(self::CIPHER_METHOD)
        );

        $encryptedRaw = openssl_encrypt($data, self::CIPHER_METHOD, $this->passPhrase, 0, $iv);

        return $encryptedRaw . "::" . bin2hex($iv);
    }

    public function decrypt(string $data): string
    {
        [$encryptedRaw, $iv] = explode("::", $data);

        return openssl_decrypt($encryptedRaw, self::CIPHER_METHOD, $this->passPhrase, 0, hex2bin($iv));
    }
}
