<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\UPS\Controller\Admin;

use XC\UPS\Core\UpsApiService;
use XLite\Core\Request;
use XLite\Core\TopMessage;

class UpsLogin extends \XLite\Controller\Admin\AAdmin
{
    public function checkFormId()
    {
        return true;
    }

    protected function doActionReturn()
    {
        $tmpToken = Request::getInstance()->temp_token;

        if ($tmpToken) {
            try {
                $startTime = time();
                UpsApiService::getInstance()->updateRefreshToken($tmpToken);
                TopMessage::getInstance()->addInfo(static::t('Connection was successful'));
            } catch (\Throwable $exception) {
                $this->getLogger('XC\UPS')->debug(
                    'Fail response: Reason connection failed',
                    ['temp_token' => $tmpToken, 'reason' => $exception->getMessage(), 'spent time in sec' => (time() - $startTime)]
                );
                TopMessage::getInstance()->addError(static::t('Reason connection failed', ['reason' => $exception->getMessage()]));
            }
        } else {
            $this->getLogger('XC\UPS')->debug('Temp token is empty or missing');

            TopMessage::getInstance()->addError(static::t('Connection failed'));
        }

        $this->redirect($this->buildURL('ups'));
    }

    protected function doActionReset()
    {
        UpsApiService::getInstance()->resetRefreshToken();
        TopMessage::getInstance()->addInfo(static::t('Connection was reset'));

        $this->redirect($this->buildURL('ups'));
    }
}
