<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ThemeTweaker\View\StickyPanel;

use XLite\Core\Request;

class ItemsListFormWithCustomizeButton extends \XLite\View\StickyPanel\ItemForm
{
    /**
     * Define widget parameters
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams[static::PARAM_ALWAYS_VISIBLE] = new \XLite\Model\WidgetParam\TypeBool('alwaysVisible', true);
    }

    /**
     * Define buttons widgets
     *
     * @return array
     */
    protected function defineButtons()
    {
        $customizeButtonStorage = new CustomizeButtonStorage((string) Request::getInstance()->target);

        return array_merge(
            parent::defineButtons(),
            $customizeButtonStorage->getCustomizeButton()
        );
    }
}
