<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ThemeTweaker\View\StickyPanel;

use XC\ThemeTweaker\Core\ThemeTweaker;
use XC\ThemeTweaker\View\Button\ThemeTweakerCustomizeStorefront;

class CustomizeButtonStorage
{
    protected string $target;

    public function __construct(string $target)
    {
        $this->target = $target;
    }

    /**
     * @return array
     */
    public function getCustomizeButton()
    {
        $customizeButton = $this->getCustomizeStorefrontButtonWidget();
        return $customizeButton
            ? ['customize' => $customizeButton]
            : [];
    }

    /**
     * @return null|\XLite\View\Button\AButton
     */
    protected function getCustomizeStorefrontButtonWidget()
    {
        $widget = null;
        $mode = $this->getModeByTarget();
        if ($mode !== '') {
            $widget = new ThemeTweakerCustomizeStorefront(
                [
                    ThemeTweakerCustomizeStorefront::PARAM_THEME_TWEAKER_MODE => $mode,
                    ThemeTweakerCustomizeStorefront::PARAM_STYLE => 'always-enabled'
                ]
            );
            $widget->init();
        }

        return $widget;
    }

    /**
     * @return string
     */
    protected function getModeByTarget()
    {
        $targetsModes = self::getTargetsThemeTweakerModes();

        return $targetsModes[$this->target] ?? '';
    }

    /**
     * @return array
     */
    protected static function getTargetsThemeTweakerModes()
    {
        return [
            'theme_tweaker_templates' => ThemeTweaker::MODE_WEBMASTER,
            'custom_css'              => ThemeTweaker::MODE_CUSTOM_CSS,
            'labels'                  => ThemeTweaker::MODE_LABELS_EDITOR,
        ];
    }
}
