<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ThemeTweaker\View\Page;

use Includes\Utils\Module\Manager;
use XCart\Domain\ModuleManagerDomain;

/**
 * Google Tag manager promo
 */
class GoogleTagManagerPromo extends \XLite\View\AView
{
    protected ?ModuleManagerDomain $moduleManagerDomain;

    public function __construct(array $params = [])
    {
        $this->moduleManagerDomain = \XCart\Container::getContainer()?->get(ModuleManagerDomain::class);

        parent::__construct($params);
    }

    /**
     * Register CSS files
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list   = parent::getCSSFiles();
        $list[] = 'modules/XC/ThemeTweaker/google_tag_manager/style.css';

        return $list;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/XC/ThemeTweaker/google_tag_manager/body.twig';
    }

    /**
     * Check module installed
     *
     * @return boolean
     */
    protected function isModuleEnabled()
    {
        return $this->moduleManagerDomain->isEnabled('XC-GoogleTagManager');
    }

    /**
     * @return boolean
     */
    protected function isModuleConfigured()
    {
        return $this->isModuleEnabled() && \XLite\Core\Config::getInstance()->XC->GoogleTagManager->container_id;
    }

    /**
     * @return string
     */
    protected function getModuleConfigURL()
    {
        return Manager::getRegistry()->getModuleSettingsUrl('XC-GoogleTagManager');
    }

    /**
     * @return string
     */
    protected function getModuleURL()
    {
        return Manager::getRegistry()->getModuleServiceURL('XC-GoogleTagManager');
    }

    /**
     * Returns current target
     *
     * @return string
     */
    protected function getCurrentTarget()
    {
        return \XLite\Core\Request::getInstance()->target;
    }
}
