<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ThemeTweaker\View\ItemsList\Model\Translation;

use XCart\Extender\Mapping\Extender;
use XC\ThemeTweaker\View\StickyPanel\ItemsListFormWithCustomizeButton;
use XLite\Core\Request;

/**
 * @Extender\Mixin
 */
class Labels extends \XLite\View\ItemsList\Model\Translation\Labels
{
    /**
     * Get panel class
     *
     * @return string|\XLite\View\Base\FormStickyPanel
     */
    protected function getPanelClass()
    {
        return $this->isDesignSection()
            ? ItemsListFormWithCustomizeButton::class
            : parent::getPanelClass();
    }

    /**
     * @return bool
     */
    protected function isDesignSection()
    {
        return Request::getInstance()->section === 'design';
    }
}
