<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ThemeTweaker\View\Button;

use XC\ThemeTweaker\Core\ThemeTweaker;

class ThemeTweakerCustomizeStorefront extends \XLite\View\Button\Link
{
    /**
     * Widget parameter names
     */
    public const PARAM_THEME_TWEAKER_MODE  = 'activate_mode';

    /**
     * Define widget parameters
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            static::PARAM_THEME_TWEAKER_MODE => new \XLite\Model\WidgetParam\TypeString('Theme Tweaker mode', $this->getDefaultThemeTweakerMode()),
        ];
    }

    /**
     * @return string
     */
    protected function getThemeTweakerMode()
    {
        return $this->getParam(static::PARAM_THEME_TWEAKER_MODE);
    }

    /**
     * return string
     */
    protected function getLocation()
    {
        return $this->getParam(static::PARAM_LOCATION);
    }

    /**
     * @return string
     */
    protected function getDefaultThemeTweakerMode()
    {
        return ThemeTweaker::MODE_LAYOUT_EDITOR;
    }

    /**
     * @return bool
     */
    protected function getDefaultBlank()
    {
        return true;
    }

    /**
     * getDefaultLabel
     *
     * @return string
     */
    protected function getDefaultLabel()
    {
        return 'Customize storefront';
    }

    /**
     * Defines the default location path
     *
     * @return null|string
     */
    protected function getDefaultLocation()
    {
        return \XLite\Core\Converter::buildURL(
            'theme_tweaker_switcher',
            '',
            ['switch' => 'on'],
            \XLite::getAdminScript()
        );
    }

    /**
     * We make the full location path for the provided URL
     *
     * @return string
     */
    protected function getLocationURL()
    {
        return \XLite::getInstance()->getShopURL($this->prepareLocationWithActivateMode());
    }

    /**
     * @return string
     */
    protected function prepareLocationWithActivateMode()
    {
        $url = $this->getLocation();
        $urlQuery = parse_url($url, PHP_URL_QUERY);
        $url .= $urlQuery ? '&' : '?';
        $url .= self::PARAM_THEME_TWEAKER_MODE . '=' . $this->getThemeTweakerMode();

        return $url;
    }

    /**
     * getDefaultStyle
     *
     * @return string
     */
    protected function getDefaultStyle()
    {
        return 'customize-storefront';
    }
}
