/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * webmaster.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/store/webmaster', [], function () {
  return {
    namespaced: true,

    state: {
      originalState: null,
      currentState: null,
      reverted: [],
      isNewTemplate: false
    },

    mutations: {
      WEBMASTER_MODE_UPDATE_STATE: function (state, value) {
        if (state.originalState === null) {
          state.originalState = value;
        }

        state.currentState = value;
      },

      WEBMASTER_MODE_UPDATE_ORIGINAL: function (state, value) {
        state.originalState = value;
      },

      WEBMASTER_MODE_ADD_TO_REVERTED: function (state, key) {
        if (state.reverted.indexOf(key) < 0) {
          state.reverted.push(key);
        }
      },

      WEBMASTER_MODE_REMOVE_FROM_REVERTED: function (state, key) {
        state.reverted = state.reverted.filter(function(item) {
          return item !== key;
        });
      },

      WEBMASTER_MODE_CLEAR_CHANGES: function (state) {
        state.originalState = null;
        state.currentState = null;
        state.reverted = [];
      },

      WEBMASTER_MODE_SET_NEW_TEMPLATE: function (state, value) {
        state.isNewTemplate = value;
      },
    },

    getters: {
      text: function (state) {
        return state.currentState;
      },

      isTextChanged: function (state) {
        return state.currentState !== state.originalState;
      },

      hasWebmasterRevertedTemplates: function (state) {
        return state.reverted.length > 0;
      }
    },

    actions: {
      addToReverted: function (ctx, key) {
        ctx.commit('WEBMASTER_MODE_ADD_TO_REVERTED', key);
      },

      removeFromReverted: function (ctx, key) {
        ctx.commit('WEBMASTER_MODE_REMOVE_FROM_REVERTED', key);
      },

      clearWebmasterChanges: function (ctx) {
        ctx.commit('WEBMASTER_MODE_CLEAR_CHANGES');
      },

      setNewTemplate: function (ctx, value) {
        ctx.commit('WEBMASTER_MODE_SET_NEW_TEMPLATE', value);
      },

      updateStoreState: function (ctx, payload) {
        ctx.commit('WEBMASTER_MODE_UPDATE_STATE', payload);
      },

      updateOriginalState: function (ctx, payload) {
        ctx.commit('WEBMASTER_MODE_UPDATE_ORIGINAL', payload);
      },
    }
  }
});
