/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * order.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/store/layout_editor', [], function () {
  return {
    namespaced: true,

    state: {
      changeset: {},
      resetAvailable: false,
      settingsState: {
        customCss: null
      },
      originalSettingsState: {
        customCss: null
      },
      images: {
        logo: null,
        favicon: null,
        appleIcon: null
      },
      banners: {}
    },

    mutations: {
      LAYOUT_EDITOR_UPDATE_CHANGESET: function (state, value) {
        Vue.set(state.changeset, value.id, value);
      },

      LAYOUT_EDITOR_UPDATE_SETTINGS_STATE: function (state, payload) {
        if (typeof(state.settingsState[payload.key]) === 'undefined') {
          return;
        }

        Vue.set(state.settingsState, payload.key, payload.value);
      },

      LAYOUT_EDITOR_UPDATE_ORIGINAL_SETTINGS_STATE: function (state, payload) {
        if (typeof(state.originalSettingsState[payload.key]) === 'undefined') {
          return;
        }

        Vue.set(state.originalSettingsState, payload.key, payload.value);
      },

      LAYOUT_EDITOR_UPDATE_IMAGE: function (state, payload) {
        if (typeof (state.images[payload.key]) !== 'undefined') {
          // handle logo images
          Vue.set(state.images, payload.key, payload.value)
        } else if (payload.key.indexOf('banner_slide_image_') === 0) {
          // handle banner slides
          if (payload.value === null) {
            Vue.delete(state.banners, payload.key)
          } else {
            var existingBannerImage = (typeof (state.banners[payload.key]) !== 'undefined') ? state.banners[payload.key] : {}

            var fullImageObject = _.extend({}, existingBannerImage, payload.value)
            fullImageObject = _.omit(fullImageObject, _.isNull)
            if (!_.isEmpty(fullImageObject)) {
              Vue.set(state.banners, payload.key, fullImageObject)
            } else {
              Vue.delete(state.banners, payload.key)
            }
          }
        }
      },

      LAYOUT_EDITOR_CLEAR_CHANGES: function (state) {
        state.images = {
          logo: null,
          favicon: null,
          appleIcon: null
        }
        state.changeset = {};
        state.banners = {};
      },

      LAYOUT_EDITOR_SET_RESET_AVAILABLE: function (state, value) {
        state.resetAvailable = value;
      }
    },

    actions: {
      updateImage: function (ctx, payload) {
        ctx.commit('LAYOUT_EDITOR_UPDATE_IMAGE', payload);
      },

      updateSettingsState: function (ctx, payload) {
        ctx.commit('LAYOUT_EDITOR_UPDATE_SETTINGS_STATE', payload);
      },

      updateOriginalSettingsState: function (ctx, payload) {
        ctx.commit('LAYOUT_EDITOR_UPDATE_ORIGINAL_SETTINGS_STATE', payload);
      },

      setResetAvailable: function (ctx, value) {
        ctx.commit('LAYOUT_EDITOR_SET_RESET_AVAILABLE', value);
      },

      clearChanges: function (ctx) {
        ctx.commit('LAYOUT_EDITOR_CLEAR_CHANGES');
      },

      updateChangeset: function (ctx, value) {
        ctx.commit('LAYOUT_EDITOR_UPDATE_CHANGESET', value);
      }
    }
  }
});
