/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * order.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/store/inline_editor', [], function () {

  return {
    namespaced: true,

    state: {
      changeset: {},
      images: {},
      videos: {},
    },

    mutations: {
      INLINE_EDITOR_UPDATE_CHANGESET: function (state, payload) {
        Vue.set(state.changeset, payload.key, payload.value);
      },

      INLINE_EDITOR_CLEAR_CHANGESET: function (state) {
        state.changeset = {};
      },

      INLINE_EDITOR_UPDATE_IMAGES: function (state, payload) {
        Vue.set(state.images, payload.key, payload.value);
      },

      INLINE_EDITOR_UPDATE_VIDEOS: function (state, payload) {
        Vue.set(state.videos, payload.key, payload.value);
      },

      INLINE_EDITOR_CLEAR_IMAGES: function (state) {
        state.images = {};
      },

      INLINE_EDITOR_CLEAR_VIDEOS: function (state) {
        state.videos = {};
      }
    },

    actions: {
      clearChangeset: function (ctx) {
        ctx.commit('INLINE_EDITOR_CLEAR_CHANGESET');
      },

      updateChangeset: function (ctx, payload) {
        ctx.commit('INLINE_EDITOR_UPDATE_CHANGESET', payload);
      },

      clearImages: function (ctx) {
        ctx.commit('INLINE_EDITOR_CLEAR_IMAGES');
      },

      updateImages: function (ctx, payload) {
        ctx.commit('INLINE_EDITOR_UPDATE_IMAGES', payload);
      },

      clearVideos: function (ctx) {
        ctx.commit('INLINE_EDITOR_CLEAR_VIDEOS');
      },

      updateVideos: function (ctx, payload) {
        ctx.commit('INLINE_EDITOR_UPDATE_VIDEOS', payload);
      },
    }
  }
});
