/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * custom_css.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/store/custom_css', [], function () {
  return {
    state: {
      originalState: null,
      currentState: null,
    },

    mutations: {
      CUSTOM_CSS_UPDATE_STATE: function (state, value) {
        if (state.originalState === null) {
          state.originalState = value;
        }

        state.currentState = _.extend(state.currentState === null ? {} : state.currentState, value);
      },

      CUSTOM_CSS_UPDATE_ORIGINAL: function (state, value) {
        state.originalState = value;
      },
    },

    getters: {
      content: function (state) {
        if (state.currentState) {
          return state.currentState['content'];
        }

        return null;
      },

      use: function (state) {
        if (state.currentState) {
          return state.currentState['use'];
        }

        return null;
      }
    },

    actions: {
      updateStoreState: function (ctx, payload) {
        ctx.commit('CUSTOM_CSS_UPDATE_STATE', payload);
      },

      updateOriginalState: function (ctx, payload) {
        ctx.commit('CUSTOM_CSS_UPDATE_ORIGINAL', payload);
      },
    }
  }
});
