/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * store/actions.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/store/actions', ['themetweaker/getters'], function (Getters) {
  return {
    state: {
      switcher: null,
      saveAvailable: true,
      switcherAvailable: true,
      bannersRemoved: []
    },

    mutations: {
      TOGGLE_SWITCHER: function (state, value) {
        state.switcher = value;
      },

      SET_SAVE_AVAILABILITY: function (state, value) {
        state.saveAvailable = value;
      },

      SET_SWITCHER_AVAILABILITY: function (state, value) {
        state.switcherAvailable = value;
      },

      ADD_BANNER_TO_REMOVE: function(state, value) {
        let isThisBannerAlreadyRemoved = false;
        state.bannersRemoved.forEach(function(banner) {
          if (banner.id === value.id)
            isThisBannerAlreadyRemoved = true;
        });
        if (!isThisBannerAlreadyRemoved) {
          state.bannersRemoved.push(value);
        }
      }
    },

    getters: {
      switcher: function (state) {
        return state.switcher;
      },

      isChanged: function (state, getters, rootState) {
        return Getters.isSaveActive(rootState);
      },

      isResetLayoutAvailable: function (state, getters, rootState) {
        return Getters.isResetLayoutActive(rootState);
      },

      saveAvailable: function (state) {
        return state.saveAvailable;
      },

      switcherAvailable: function (state) {
        return state.switcherAvailable;
      },

      bannersRemoved: function (state) {
        return state.bannersRemoved;
      }
    },

    actions: {
      toggleSwitcher: function (ctx, value) {
        ctx.commit('TOGGLE_SWITCHER', value);
      },

      addBannerToRemove: function (ctx, value) {
        ctx.commit('ADD_BANNER_TO_REMOVE', value);
      },

      setSwitcherState: function (ctx, value) {
        ctx.commit('TOGGLE_SWITCHER', value);
      },

      hideSwitcher: function (ctx) {
        ctx.commit('SET_SWITCHER_AVAILABILITY', false);
      },

      hideSaveButton: function (ctx) {
        ctx.commit('SET_SAVE_AVAILABILITY', false);
      },
    }
  }
});
