/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Webmaster mode component
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/panel/actions',
  [
    'js/vue/vue',
    'keymaster/key',
    'themetweaker/getters',
    'vue/eventbus'
  ],
  function (XLiteVue, Key, Getters, EventsHub) {
  XLiteVue.component('xlite-panel-actions', {
    props: ['mode'],

    mounted: function () {
      xcart.trigger('panel-actions.ready', this);
      this.assignHotkeys();
    },

    watch: {},

    computed: {
      switcher: function () {
        return this.$store.getters.switcher;
      },

      isChanged: function () {
        return this.$store.getters.isChanged;
      },

      isResetLayoutAvailable: function () {
        return this.$store.getters.isResetLayoutAvailable;
      },

      saveAvailable: function () {
        return this.$store.getters.saveAvailable;
      },

      switcherAvailable: function () {
        return this.$store.getters.switcherAvailable;
      },

      switcherLabel: function () {
        switch (this.mode) {
          case 'webmaster':
            return xcart.t('Pick templates from page');
          case 'layout_editor':
            return xcart.t('Drag-n-drop blocks');
          case 'custom_css':
            return xcart.t('Use custom CSS');
          case 'labels_editor':
            return xcart.t('Highlight labels');
        }
      },

      switcherClasses: function () {
        return {
          'hidden': !this.switcherAvailable,
        }
      },

      filterChangeState: function () {
        const layoutBannersState = this.$store.state.layoutEditor.banners;
        const addBanner = layoutBannersState[Object.keys(layoutBannersState)[0]]
          ? layoutBannersState[Object.keys(layoutBannersState)[0]].add_banner
          : false;

        return addBanner || !this.isChanged;
      },

      saveButtonClasses: {
        cache: false,
        get: function () {
          return {
            'disabled': this.filterChangeState,
            'hidden': !this.saveAvailable
          }
        }
      },

      isSaveDisabled: {
        cache: false,
        get: function () {
          return this.filterChangeState;
        }
      },

      isLayoutEditorMode: function () {
        return this.mode === 'layout_editor';
      },

      resetLayoutBtnClasses: {
        cache: false,
        get: function () {
          return {
            'disabled': !this.isResetLayoutAvailable,
            'hidden': !this.isLayoutEditorMode
          }
        }
      }
    },

    methods: {
      assignHotkeys: function () {
        Key.filter = function (event) {
          var element = event.target || event.srcElement;

          if ($(element).closest('.themetweaker-panel').length > 0) {
            return true;
          }

          return !(element.tagName === 'INPUT' || element.tagName === 'SELECT' || element.tagName === 'TEXTAREA');
        };

        Key('⌘+/, ctrl+/', _.bind(this.onSwitchShortcut, this));
        Key('⌘+s, ctrl+s', _.bind(this.onSaveShortcut, this));
      },

      onSaveClick: function () {
        EventsHub.$emit('triggerSave');
      },

      onSwitchChange: function (event) {
        this.$store.dispatch('toggleSwitcher', event.target.checked);
      },

      onSaveShortcut: function (event, handler) {
        this.onSaveClick();
        return false;
      },

      onSwitchShortcut: function (event, handler) {
        this.$store.dispatch('toggleSwitcher', !this.switcher);
        return false;
      },

      hidePanel: function () {
        EventsHub.$emit('triggerHide');
      },

      resetLayout: function () {
        if (!this.isLayoutEditorMode || !this.isResetLayoutAvailable) {
          return;
        }

        EventsHub.$emit('showResetLayoutConfirm', function () {
          EventsHub.$emit('action.reset');
        }, null);
      }
    }
  });
});
