/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * modal.js
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/panel/modal', ['js/vue/vue', 'vue/eventbus'], function (XLiteVue, EventBus) {
  XLiteVue.component('xlite-themetweaker-modal', {
    template: document.querySelector('#themetweaker-modal-template').innerHTML,

    props: {
      namespace: {
        type: String
      },
      show: {
        type: Boolean,
        required: true,
      }
    },

    beforeMount: function () {
      xcart.trigger('modal.activate', this);
    },

    mounted: function () {
      xcart.trigger('modal.ready', this);
    },

    methods: {
      sendEvent: function (name) {
        EventBus.$emit(this.namespace + '.' + name, this);
      },

      sendCancelEvent: function () {
        EventBus.$emit(this.namespace + '.cancel', this);
      },
    }
  });
});
