/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * blocks_list.js
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/blocks_list', ['vue/eventbus'], function (EventBus) {
  return {
    data: function () {
      return {};
    },

    methods: {
      prepareListItems: function (items) {
        items = items.map(function (item) {
          return Object.assign({
            'weight': 10000,
            'settings_link': false,
            'is_movable': false,
            'can_hide': false,
            'is_hidden': false,
            'help': false,
            'is_removable': false,
            'has_body': false,
          }, item);
        });

        items = items.sort(function (item1, item2) {
          return item1.weight - item2.weight;
        });

        items.forEach(_.bind(this.correctItemWrappers, this));

        return items;
      },

      getItemData: function (item) {
        var data = {};
        if (
          item.data('bodyentityid')
          || item.data('isbutton')
          || item.hasClass('list-item__hidden')
          || item[0].getBoundingClientRect().height > 0
          || item.data('lazyload')
        ) {
          data = {
            id: item.data('id'),
            name: item.data('blockname') !== undefined ? item.data('blockname') : 'Layout block',
            weight: item.data('weight'),
            is_movable: !item.data('isbutton'),
            can_hide: !item.data('isbutton'),
            bodyEntityId: item.data('bodyentityid') ? item.data('bodyentityid') : '',
            has_body: item.data('bodyentityid') ? true : false,
            button_class: item.data('isbutton') ? 'add-block-button' : '',
            is_button: item.data('isbutton'),
            is_removable: item.data('removeid') ? item.data('removeid') : '',
            is_hidden: item.hasClass('list-item__hidden'),
            settings_link: item.data('settings-link'),
            help: item.data('help-message'),
            element_data: item.data(),
            element: item
          };
        }

        return data;
      },

      addItemAddBlock: function (items, selector, idPrefix, elementWeightOffset) {
        var self = this;
        var maxWeight = items && items.length ? items[items.length - 1].weight : 10;
        return items.concat(jQuery(selector).toArray().reduce(function (blocks, elem) {
          elem = jQuery(elem).children('div').eq(0);
          var itemData = self.getItemData(elem);
          if (!_.isEmpty(itemData)) {

            let elemWeight = typeof elementWeightOffset === 'undefined' ? maxWeight : elementWeightOffset;
            itemData.weight = itemData.weight + (itemData.is_button ? (maxWeight + 1000) : elemWeight);
            itemData.id = itemData.id + idPrefix;
            blocks.push(itemData);
            maxWeight = maxWeight + 10;
          }
          return blocks;
        }, []));
      },

      goAdminSettingsPage: function (params, event) {
        if (event && event.stopPropagation) {
          event.stopPropagation();
        }
        var url = URLHandler.buildURL(_.extend(
            params,
            { 'base': xliteConfig.admin_script }
          )
        );
        window.open(url, '_blank');
      },

      removeSwitcherHandler: function (item, event) {
        event.stopPropagation();
        var switcher = jQuery(event.target);
        var groupItem = switcher.closest('.group-item');
        EventBus.$emit('action.remove-entity', { 'id': item.element.data('removeid'), 'element': groupItem });
      },

      itemClickHandler: function (item, vueDataIndex, vueDataSubIndex, event) {
        if (item.is_button) {
          if (item.button_class === 'add-block-button') {
            item.button_class = 'add-block-button disabled';
          }

          var items = [];
          item = {
            name: 'Banner',
            button_class: 'new-banner'
          };
          items.push(item);
          if (this[vueDataIndex]) {
            if (typeof vueDataSubIndex === 'number') {
              newItemPostion = this[vueDataIndex][vueDataSubIndex].items.length;
              this[vueDataIndex][vueDataSubIndex].items.splice(newItemPostion - 1, 0, this.prepareListItems(items)[0]);
            } else {
              newItemPostion = this[vueDataIndex].length;
              this[vueDataIndex].splice(newItemPostion - 1, 0, this.prepareListItems(items)[0]);
            }

            EventBus.$emit('action.add-entity', { 'type': vueDataIndex, 'subtype': vueDataSubIndex });
          }
        } else if (
          event
          && (
            event.currentTarget === event.target.parentElement
            || $(event.target).hasClass('main-text')
          )
          && item.element
          && item.element.hasClass('list-item__hidden') === false
        ) {
          let $el = $(event.currentTarget);
          let block = item.element;

          $('.list-items-group .list-item').not(block).removeClass('selected');
          $('.layout-options-wrapper .group-item').not($el).removeClass('selected');

          $el.toggleClass('selected');
          block.toggleClass('selected');
          if (block.hasClass('selected')) {
            block.listItem('selected');
          }
        }

        if (item.name === 'Banner') {
          EventBus.$emit('triggerSave');
        }
      },

      itemMouseenterHandler: function (item, event) {
        if (!item.is_button && item.element) {
          item.element.addClass('themetweaker-hover');
        }
      },

      itemMouseleaveHandler: function (item, event) {
        if (!item.is_button && item.element) {
          item.element.removeClass('themetweaker-hover');
        }
      },

      correctItemWrappers: function(item) {
        const block = item.element;

        if (block && !block.is('list-item')) {
          block.addClass('list-item');
          /* Fake list-item wrappers because not every element in the menu have them, but every menu item needs them */
          block.parent().addClass('list-items-group')
          block.parent().parent().addClass('list-container')
        }
      }
    }
  };
});
