/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Set of layout banner components
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/layout_banners', ['js/vue/vue', 'vue/vuex', 'vue/eventbus', 'themetweaker/blocks_list', 'themetweaker/layout_groups'], function (XLiteVue, Vuex, EventBus, BlocksListMixin) {
  $('[id^=banner_id_for_sb_]').each(function () {
    var htmlItem = this;
    // get suffix number which is banner id actually
    var banner_id = htmlItem.id.replace(/^[a-zA-Z_]*/, '');
    XLiteVue.component('xlite-layout-banner' + banner_id, {

      mixins: [BlocksListMixin],

      methods: {
        goBannerAdminPage: function (bannerId, tab) {
          var tab = tab ? tab : 'info';
          var settings_link = {'target': 'banner_edit', 'id': parseInt(bannerId), 'page': tab}
          this.goAdminSettingsPage(settings_link);
        },
      },

      template: $('#' + htmlItem.id).html()

    })
  })
})
