/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * file uploader controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('multiple_file_uploader', [
  'vue/vue',
  'js/vue/vue',
  'vue/eventbus',
  'themetweaker/blocks_list',
  'file_uploader'
], function (Vue, XLiteVue, EventBus, BlocksListMixin) {
  XLiteVue.component('xlite-multiple-file-uploader', {
    mixins: [BlocksListMixin],


    ready: function () {
      this.processSortable()
      this.repositionFiles(true)

      this.$nextTick(function () {

        /* context menu for slides */
        setTimeout(function () {
          if (typeof tippy !== 'undefined') {
            tippy('.slide-settings-dots', {
              content (reference) {
                const id = reference.getAttribute('data-template')
                const template = document.getElementById(id)
                if (template) {
                  template.style.display = 'block'
                }
                return template
              },
              appendTo: document.getElementById('layout-editor-panel'),
              allowHTML: true,
              interactive: true,
              trigger: 'click',
              hideOnClick: true
            })
          }
        }, 0)

        /*Sortable feature*/
        var self = this
        Sortable.create(this.$el, {
          handle: '.slide-settings-move',
          animation: 150,
          ghostClass: 'sortable-ghost',  // Class name for the drop placeholder
          filter: '.add-new-slide-component',
          draggable: '.banner-item',
          store: {
            /**
             * Get the order of elements. Called once during initialization.
             * @param   {Sortable}  sortable
             * @returns {Array}
             */
            get: function (sortable) {
              return []
            },

            /**
             * Save the order of elements. Called onEnd (when the item is dropped).
             * @param {Sortable}  sortable
             */
            set: function (sortable) {
              var newOrder = sortable.toArray()
              newOrder.forEach(function (slideId, bannerPosition) {
                self.updateImage({key: slideId, value: {slidePosition: (bannerPosition + 1) * 10}})
              })
            }
          }
        })
      })
    },

    events: {
      'new-file-uploaded': function (index, data, fileUploader) {
        if (!_.isEqual(this, fileUploader.$parent)) {
          // this an event from not my child
          return true
        }
        var element = jQuery(data).find('xlite-file-uploader')

        if (element.length) {
          var anchorElement = jQuery(fileUploader.getFileUploaderElement())
          anchorElement = anchorElement.siblings().toArray().reduce(function (carry, item) {
            var current = jQuery(item)
            var next = current.next('div.file-uploader.item')

            if (!next.length) {
              return carry
            }

            var currentIndex = parseInt(current.attr('data-position-index'))
            var nextIndex = parseInt(next.attr('data-position-index'))

            if (isNaN(currentIndex) && isNaN(nextIndex)) {
              return carry
            }

            if (isNaN(currentIndex) && nextIndex > index) {
              return next
            }

            if (currentIndex < index && nextIndex > index) {
              return next
            }

            return carry
          }, anchorElement)

          element.insertBefore(anchorElement)
          var v = new Vue()
          element.attr('data-position-index', index)
          v.$mount(element.get(0))
        }

        fileUploader.unassignWait()
        this.repositionFiles(true)
      },
      'before-new-files-uploaded': function (fileUploader) {
        jQuery(fileUploader.getFileUploaderElement()).siblings().removeAttr('data-position-index')
      }
    },

    methods: _.extend({},
      Vuex.mapActions('layoutEditor', [
        'updateImage'
      ]),
      {
        goBannerAdminPage: function (bannerId) {
          var settings_link = {'target': 'banner_edit', 'id': parseInt(bannerId)}
          this.goAdminSettingsPage(settings_link)
        },
        deleteSlide: function (slideId) {
          var self = this
          EventBus.$emit('showDeleteBannerConfirm', _.partial(function (slideId) {
              let updateData = {is_delete_slide: true}
              $('div[data-id="' + slideId + '"]').children().addClass('opacity-hide')
              self.updateImage({key: slideId, value: updateData})
            }, slideId),
            null,
            'slide'
          )
        },
        toggleSlide: function (slideId, event) {
          let updateData = {disableSlide: $(event.target).hasClass('slide-settings-show') ? 1 : 0}
          $(event.target).toggleClass(['slide-settings-show', 'slide-settings-hide'])
          $(event.target).parent().siblings().each(function () {
            $(this).toggleClass(['opacity-show', 'opacity-hide'])
          });
          this.updateImage({key: slideId, value: updateData})
        },
        updateBannerLink: function (slideId, event) {
          let updateData = {link: event.target.value}
          this.updateImage({key: slideId, value: updateData})
        },
        getMultipleFileUploaderElement: function () {
          return $(this.$el).closest('.multiple-files')
        },
        processSortable: function () {
          var self = this
          this.getMultipleFileUploaderElement().sortable({
            placeholder: 'ui-state-highlight',
            forcePlaceholderSize: false,
            distance: 10,
            items: '> div.item',
            update: function (event, ui) {
              self.repositionFiles()
            },
            activate: function (event, ui) {
              if (ui.item.hasClass('open')) {
                ui.item.find('.link').dropdown('toggle')
              }
            }
          })
        },
        repositionFiles: function (saveAsInitial) {
          base = jQuery(this.getMultipleFileUploaderElement())

          var min = 10
          base.find('input.input-position').each(function () {
            min = parseInt(10 === min ? min : Math.min(this.value, min))
          })

          base.find('input.input-position').each(function () {
            jQuery(this).val(min)

            var vm = Vue.getClosestVueInstance(this)
            if (vm) {
              if (vm.position === undefined && vm.$children.length !== 0 && vm.$children[0].position !== undefined) {
                vm = vm.$children[0]
              }
              vm.position = min
            }

            if (saveAsInitial) {
              if (this.commonController) {
                this.commonController.saveValue()
              }

            } else {
              jQuery(this).change()
            }
            min += 10
          })
        }
      })
  })
})
