/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Layout editor component
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/layout_editor', ['js/vue/vue', 'vue/vuex', 'vue/eventbus'], function (XLiteVue, Vuex, EventBus) {
  XLiteVue.component('xlite-layout-editor', {
    props: ['preset'],

    data: function () {
      return {
        loaded: false
      }
    },

    mounted: function () {
      xcart.trigger('layout-editor.ready', this);
      jQuery('.group-item.bs-accordion .bs-accordion-body').on('hide.bs.collapse', function () {
        jQuery(this).closest('.group-item.bs-accordion').removeClass('bs-expanded').addClass('bs-collapsed');
      });
      jQuery('.group-item.bs-accordion .bs-accordion-body').on('show.bs.collapse', function () {
        jQuery(this).closest('.group-item.bs-accordion').removeClass('bs-collapsed').addClass('bs-expanded');
      });

      this.$nextTick(_.bind(function () {
        this.loaded = true;
      }, this));
    },

    computed: _.extend({},
      Vuex.mapState('layoutEditor', [
        'changeset',
        'images',
        'banners',
        'settingsState'
      ]),

      Vuex.mapGetters([
        'switcher'
      ]),{

      panelClasses: function () {
        return {
          'themetweaker-sections': true,
          'layout-editor--initial': !this.loaded,
          'layout-editor--disabled': !this.switcher
        }
      }
    }),

    events: {
      'action.save': function () {
        var params = {
          'preset': this.preset,
          'changes': this.changeset,
          'settingsState': this.settingsState,
          'returnURL': window.location.href
        };

        for (var type in this.images) {
          if (this.images[type] !== null) {
            params[type] = this.images[type];
          }
        }

        for (var type in this.banners) {
          if (this.banners[type] !== null) {
            params[type] = this.banners[type]
          }
        }

        params[xliteConfig.form_id_name] = xliteConfig.form_id;

        xcart.post(
          {
            base: xliteConfig.admin_script,
            target: 'layout_edit',
            action: 'apply_changes'
          },
          null,
          params
          )
          .done(_.bind(this.onSaveSuccess, this))
          .fail(_.bind(this.onSaveFail, this));
      }
    },

    methods: _.extend({},
      Vuex.mapActions('layoutEditor', [
        'clearChanges',
        'setResetAvailable',
      ]), {

      onDragStart: function () {
        $('#themetweaker-panel').addClass('collapsed');
      },

      onDragStop: function () {
        $('#themetweaker-panel').removeClass('collapsed');
      },

      onSaveSuccess: function (event) {
        this.$nextTick(function () {
          if (!TopMessages.instance.hasVisibleMessages()) {
            xcart.trigger('message', {type: 'info', message: xcart.t('Changes were successfully saved')});
          }
        });

        this.clearChanges();
        this.setResetAvailable(true);
        EventBus.$emit('completed.save', function () {
          window.location.reload();
        });
      },

      onSaveFail: function (event) {
        xcart.trigger('message', {type: 'error', message: xcart.t('Unable to save changes')});
        EventBus.$emit('failed.save');
      },
    })
  });
});
