/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Slidebar
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function ListContainer(element) {
  this.base = $(element);
  this.instances = [];

  var self = this;
  var groups = $(this.base).find('.group-items.movable-group');

  $('.group-item').mouseenter(function () {
    if (!$(this).closest('.group-items').hasClass('group-items__on-move')) {
      $(this).removeClass('group-item__not-hoverable');
    }
  })

  groups.each(function () {
    var instance = Sortable.create(this, {
      animation: 150,
      handle: '.themetweaker-panel-move',
      group: 'common',
      ghostClass: "sortable-ghost",  // Class name for the drop placeholder
      chosenClass: "sortable-chosen",  // Class name for the chosen item
      dragClass: "sortable-drag",
      onStart: _.bind(self.onStart, self),
      onEnd: _.bind(self.onEnd, self),
      onMove: _.bind(self.onMove, self),
      filter: ".group-item-hidden",
    });

    this.querySelectorAll('.themetweaker-panel-move').forEach((mover) => {
      mover.addEventListener("click", function(e) {
        e.stopPropagation();
      });
    });

    self.instances.push(instance);
  });
}

ListContainer.prototype.move = function (item) {
  var from = item.closest('.list-items-group');
  var center = $('.list-items-group[data-list="center"]');

  if (center.length > 0) {
    center.append(item);
    var event = new Event('add');
    event.from = from;
    event.to = center;
    event.item = item;
    this.onAdd(event);
  } else {
    console.error('Can\'t move item to center group, because it doesn\'t exist');
  }
};

ListContainer.prototype.onStart = function (event) {
  xcart.trigger('layout.dragStart');
  $('.group-item').addClass('group-item__not-hoverable');
  $('.group-items').addClass('group-items__on-move');
};

ListContainer.prototype.onEnd = function (event) {
  $('.group-items').removeClass('group-items__on-move');
  xcart.trigger('layout.dragStop');
};

ListContainer.prototype.onRemove = function (event) {

};


ListContainer.prototype.onFilter = function (event) {

};

ListContainer.prototype.onMove = function (event) {
  xcart.trigger(
    'layout.listElemMoved',
    event
  );
};

xcart.autoload(ListContainer, '.layout-editor-sidebar');
