/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * List item
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

(function ($) {
  var undefined;

  var options = {
    prefix: 'list-item__'
  };

  var focusAction = function (element) {
    let stickyElements = [];
    const additionalSpace = 20;
    const elem = element.get(0);
    const scrollStart = window.pageYOffset;
    let elemStartPosition = elem.getBoundingClientRect().top;
    let scrollBy = 0;
    let scrolledByOnPreviousStep = null;
    let elemTopOnPreviousStep = null;

    const recalculateScrollCoords = function() {
      window.themeTweakerStickyElements = [
        '.desktop-header',
        '.themetweaker-panel--header'
      ];
      const evt = new CustomEvent('themeTweakerStickyElementsCollect');
      window.dispatchEvent(evt);
      stickyElements = window.themeTweakerStickyElements.slice(0, window.themeTweakerStickyElements.length);
      const elemCurrentTop = elem.getBoundingClientRect().top;
      if (
        scrolledByOnPreviousStep !== null
        && elemTopOnPreviousStep !== null
        && elemCurrentTop !== elemTopOnPreviousStep - scrolledByOnPreviousStep
      ) {
        elemStartPosition += (elemCurrentTop - elemTopOnPreviousStep + scrolledByOnPreviousStep);
      }
      scrollBy = elemStartPosition - additionalSpace;
      stickyElements.forEach(function(selector) {
        if (typeof selector === 'function') {
          scrollBy -= selector();
        } else if (typeof selector === 'string') {
          document.querySelectorAll(selector).forEach(function(element) {
            scrollBy -= element.getBoundingClientRect().height;
          });
        } else if (typeof selector === 'object' && typeof selector.getBoundingClientRect === 'function') {
          scrollBy -= selector.getBoundingClientRect().height;
        }
      });
      elemTopOnPreviousStep = elemCurrentTop;
    }
    recalculateScrollCoords();

    const timeStart = Date.now();
    const duration = 300;
    const frameStep = function() {
      const percentage = Math.min(((Date.now() - timeStart) / duration), 1);
      const step = 1 - ( 1 - percentage ) * ( 1 - percentage );
      recalculateScrollCoords();
      scrolledByOnPreviousStep = Math.round(scrollStart + scrollBy * step) - window.pageYOffset;
      window.scrollTo(0, Math.round(scrollStart + scrollBy * step));
      if (percentage < 1)
        requestAnimationFrame(frameStep);
    }
    requestAnimationFrame(frameStep);
  }

  var methods = {
    focus: function () {
      let element = $(this);
      $(this).on('animationend', _.once(function () {
        focusAction(element);
      }));
    },
    selected: function () {
      focusAction($(this));
    },
    show: function () {
      this.each(function () {
        $(this).on('animationend', _.once(function () {
          $(this).removeClass(options.prefix + 'showing');
          $(this).css('max-height', '');
        }));
        $(this).css('max-height', $(this).data('height'));
        $(this).removeClass(options.prefix + 'hidden');
        $(this).removeClass(options.prefix + 'sidebar-hidden');
        $(this).addClass(options.prefix + 'showing');
      });
    },
    hide: function () {
      this.each(function () {
        $(this).data('height', $(this).outerHeight());
        $(this).css('max-height', $(this).outerHeight());
        $(this).on('animationend', _.once(function () {
          $(this).removeClass(options.prefix + 'hiding');
          $(this).addClass(options.prefix + 'hidden');
          $(this).css('max-height', 0);
        }));
        $(this).addClass(options.prefix + 'hiding');
      });
    },
    isHidden: function () {
      return this.hasClass(options.prefix + 'hidden') || this.hasClass(options.prefix + 'temporary');
    },
    isSidebarHidden: function() {
      return this.hasClass(options.prefix + 'sidebar-hidden');
    },
  };

  $.fn.listItem = function (method) {
    if (methods[method]) {
      return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
    } else if (typeof method === 'object' || !method) {
      return methods.init.apply(this, arguments);
    } else {
      $.error('Метод с именем ' + method + ' не определен для jQuery.listItem');
    }
  };
})(jQuery);
