/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Layout type select component
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('themetweaker/layout_type_select', ['js/vue/vue', 'vue/eventbus'], function (XLiteVue, EventBus) {
  XLiteVue.component('xlite-layout-type', {
    props: ['group', 'opts', 'value'],

    data: function () {
      return {
        showMenu: false,
        options: JSON.parse(this.opts),
        selected: this.value
      }
    },

    mounted: function () {
      var self = this;

      this.$nextTick(function () {
        $(document).click(function (event) {
          var target = $(event.target);
          if (target.closest(self.$el).length === 0) {
            self.showMenu = false;
          }
        });
      });
    },

    watch: {
      'selected': function (value, oldValue) {
        if (oldValue !== null) {
          EventBus.$emit('layout-type.selected', value, this);
        }
      }
    },

    methods: {
      getLayoutTypeOptionMarkup: function (key) {
        var container = $('.option-image-container', this.$el);
        return container.find('.option-image.' + key).html();
      },

      toggleMenu: function (event) {
        this.showMenu = !this.showMenu;
      },

      onSelect: function (option) {
        this.selected = option;
        // this.showMenu = false;
      }
    }
  });
});
