/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Stripe fast-lane extender
 *
 * Copyright (c) 2001-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('stripe/checkout_fastlane/sections/payment/place_order',
  [
    'checkout_fastlane/sections/payment/place_order',
    'checkout_fastlane/sections/section_change_button'
  ],
  function (PlaceOrder, SectionChangeButton) {
    PlaceOrder = SectionChangeButton.component('place-order');

    let parent = PlaceOrder.options.methods.placeOrder

    PlaceOrder = PlaceOrder.extend({
      methods: {
        placeOrder: function () {
          // prevent double submission
          if (!this.blocked) {
            parent.apply(this, arguments)
          }
        }
      }
    });

    Vue.registerComponent(SectionChangeButton, PlaceOrder);

    return PlaceOrder;
  }
);

