<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\SagePay\LifetimeHook\Upgrade;

use XCart\Doctrine\FixtureLoader;
use XLite\Model\Payment\Method;

final class UpgradeTo550build4
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . 'XC/SagePay/resources/hooks/upgrade/5.5/0.4/upgrade.yaml');
        if ($this->changeName()) {
            \XLite\Core\Database::getEM()->flush();
        }
    }

    private function changeName(): bool
    {
        /** @var \XLite\Model\Payment\Method $method */
        $method = \XLite\Core\Database::getRepo(Method::class)?->findByServiceName('Opayo form protocol') ?: null;

        if (!$method) {
            return false;
        }

        if ($method->getName() === 'Opayo form protocol') {
            $method->setName('Opayo gateway - Form protocol');
        }
        \XLite\Core\Database::getEM()->persist($method);

        return true;
    }
}
