<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\Reviews\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XC\Reviews\Model\Review;

final class ReviewCallback
{
    public function prePersist(Review $review, LifecycleEventArgs $args): void
    {
        if (!$review->getAdditionDate()) {
            $review->setAdditionDate(\XLite\Core\Converter::time());
        }
    }
}
