<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XC\ProductVariants\View\Product\Details\Customer;

use XCart\Extender\Mapping\Extender;

/**
 * Stock
 * @Extender\Mixin
 */
class Stock extends \XLite\View\Product\Details\Customer\Stock
{
    /**
     * Check if varant is out-of-stock
     *
     * @return boolean
     */
    protected function isShowStockWarning()
    {
        return $this->getProductVariant()
            ? $this->getProductVariant()->isShowStockWarning()
            : parent::isShowStockWarning();
    }

    /**
     * Return available amount
     *
     * @return integer
     */
    protected function getAvailableAmount()
    {
        return $this->getProductVariant() && $this->getAttributeValues()
            ? $this->getProductVariant()->getAvailableAmount()
            : parent::getAvailableAmount();
    }

    /**
     * Return available amount
     *
     * @return integer
     */
    protected function getItemsInCart()
    {
        return $this->getProductVariant()
            ? $this->getProductVariant()->getItemsInCart()
            : parent::getItemsInCart();
    }

    /**
     * Return available amount message
     *
     * @return integer
     */
    protected function getItemsInCartMessage()
    {
        return $this->getProductVariant()
            ? $this->getProductVariant()->getItemsInCartMessage()
            : parent::getItemsInCartMessage();
    }

    /**
     * Check - 'items available' label is visible or not
     *
     * @return boolean
     */
    protected function isInStock()
    {
        $result = parent::isInStock();
        $variant = $this->getProductVariant();

        if ($variant && $this->getAttributeValues()) {
            if ($variant->getDefaultAmount()) {
                $result = $this->getProduct()->getInventoryEnabled() && !$variant->isOutOfStock();
            } else {
                $result = !$variant->isOutOfStock();
            }
        } elseif ($this->getProduct()->mustHaveVariants()) {
            $result = false;
        }

        return $result;
    }

    /**
     * Return 'Out of stock' message
     *
     * @return string
     */
    protected function getOutOfStockMessage()
    {
        return $this->getProduct()->mustHaveVariants()
            ? static::t($this->getProductVariant() ? 'This item is out of stock' : 'This item is not available')
            : parent::getOutOfStockMessage();
    }
}
