<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\ProductVariants\Transformer\XLite\Model\Product\Logic\Entity\Storefront;

use XCart\Logic\Entity\Storefront\Image;
use XCart\Transformer\XLite\Model\Product\Logic\Entity\Storefront\ProductInterface;
use XLite\Model\Product as Source;
use XCart\Logic\Entity\Storefront\Product as Target;
use XCart\Logic\Entity\Storefront\ProductVariant;
use XC\ProductVariants\Transformer\XC\ProductVariants\Model\ProductVariant\Logic\Entity\Storefront\ProductVariantInterface as VariantTransformer;

class ProductDecorator implements ProductInterface
{
    public function __construct(
        private ProductInterface $inner,
        private VariantTransformer $variantTransformer
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        /** @var \XC\ProductVariants\Model\ProductVariant|null $defaultVariant */
        if ($defaultVariant = $input->getDefaultVariant()) {
            $target->setSku($defaultVariant->getDisplaySku());
            $target->setPrice($defaultVariant->getClearPrice());
            $target->setWeight($defaultVariant->getClearWeight());
            $target->setAmount($defaultVariant->getPublicAmount());

            if ($defaultVariantImage = $defaultVariant->getImage()) {
                $transformedDefaultVariantImage = (new Image())
                    ->setUrl($defaultVariantImage->getFrontURL())
                    ->setAlt($defaultVariantImage->getAlt())
                    ->setWidth($defaultVariantImage->getWidth())
                    ->setHeight($defaultVariantImage->getHeight());

                $target->setImages([$transformedDefaultVariantImage]);
            }
        }

        $target->setVariants($this->getTransformedVariants($input));

        return $target;
    }

    /**
     * @return ProductVariant[]
     */
    private function getTransformedVariants(Source $input): array
    {
        $transformedVariants = [];

        /* @var \XC\ProductVariants\Model\ProductVariant $variant */
        foreach ($input->getVariants() as $inputVariant) {
            $transformedVariants[] = $this->variantTransformer->transform($inputVariant);
        }

        return $transformedVariants;
    }
}
