<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XC\ProductVariants\Transformer\XLite\Model\OrderItem\Logic\Entity\Storefront\Cart;

use XCart\Transformer\XLite\Model\OrderItem\Logic\Entity\Storefront\Cart\NewItemInterface;
use XLite\Model\OrderItem as Source;
use XCart\Logic\Entity\Storefront\Cart\NewItem as Target;
use XC\ProductVariants\Transformer\XC\ProductVariants\Model\ProductVariant\Logic\Entity\Storefront\ProductVariantInterface as VariantTransformer;

class NewItemDecorator implements NewItemInterface
{
    public function __construct(
        private NewItemInterface $inner,
        private VariantTransformer $variantTransformer
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        if ($input->getVariant()) {
            $target->setVariant(
                $this->variantTransformer->transform($input->getVariant())
            );
        }

        return $target;
    }
}
